/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

float filter_window=0.01;
vec3 minimumFilter(sampler2D tex, vec2 uv, vec3 ratio)
{
    mediump float wsize = filter_window/14.0;
    mediump float wstep = 2.0;
    vec3 res = vec3(1000.0,1000.0,1000.0);
    for (float i = -7.0; i <= 7.0; i++) {
        for (float j= -7.0; j<= 7.0; j++) {
        	vec3 tmp=texture2D(iChannel0,uv+vec2(float(i)*wsize,float(j)*wsize)).rgb;   
            tmp*=ratio;
           	res = min(res,tmp);
        }
    }
    float channeldark=min(min(res[0],res[1]),res[2]);
    res=vec3(channeldark,channeldark,channeldark);

    return res;
}


void main( void )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    vec3 base = texture2D(iChannel0,uv*vec2(1.0,-1.0)).rgb;

    vec3 color_A = vec3(1.0,1.0,1.0);
 //    texture2D(iChannel0,-iMouse.xy/iResolution.xy).rgb;
    
//    # get transmission
    vec3 res_t = 1.0-0.95*minimumFilter(iChannel0,uv*vec2(1.0,-1.0),color_A);
	res_t = max(vec3(1e-3),min(vec3(0.99),res_t));
    
	gl_FragColor = vec4(res_t,1.0);
    
}

